[**Oklahoma NG911 Toolkit**](README.html) | [Prep] | [Enhancement] | [Validation] | [MSAG] | [Comparison] | [Submission]

**Supplementary Documentation** | [Examples] | [Topology Rules] | [***Change Log***] | [Error Glossary]

# **Oklahoma Next-Generation 9-1-1 Pro Toolkit**

## **Credits**

### Oklahoma Adaptation

Scripts written by Riley Baird and Emma Baker with the Oklahoma Transportation Cabinet (OTC)

##### Last Revised:

August 18, 2025

## **Abstract**

This is a log of changes to the NG911 GIS Pro Toolkit since Version 3.0.0.

## **Most Recent Changes**

### **Version 3.0.0**

* First general availability release!
* Issue #17 - Fixed problem with RCLMatch/RCLSide analysis.

## **Previous Changes**

### **Version 3.0.0-beta.1**

* Issue #2 - False uniqueness errors for certain cases involving road centerlines fixed.
* Issue #17 - **Still outstanding** as of this release; partially addressed. See [this comment](https://github.com/OKDOT-GIS/NG911-Pro/issues/17#issuecomment-3192611415) on #17 for workaround.
* Improvements and error-code changes to *Check ESN Attribute (Road Centerline)* validation routine.

### **Version 3.0.0-alpha.5**

* Issues #5 & #16 - Reworked the *Check ESN Attribute (Road Centerline)* validation routine's logic
* Issue #9 - Removed unnecessary *Check MSAGComm Consistency* validation routines
* Issue #10 - Reworked the *Check Address Range Directionality* validation routine's logic
* Issue #16 - Added `fill_value` of `"0"` for fields with roles `esn`, `esn_l`, and `esn_r` to `config.yml`
* Issue #18 - Removed non-functional fishbone analysis tool
* Issue #19 - Most tools now have output parameters
* Issue #21 - Improved NGUID format diagnostic messages
* Reworked the *Check Topology* validation routine's logic
* Improved *Validate Geodatabase* interface

### **Version 3.0.0-alpha.4**

* Issue #11 - Rebuilt `4 - Create Standard ESZ & ESB Feature Classes`, fixing a crash due to a field-type/value-type mismatch.
* Issue #13 - Fixed an issue in `Validate Geodatabase` causing false-positive reports of `ERROR:GENERAL:UNIQUENESS` with address points.
* Issue #20 - Fixed an issue where some fields were not being copied over during field mapping.

### **Version 3.0.0-alpha.3**

This update included:

* Validation routine *Check Topology* was added to `Validate Geodatabase`.

### **Version 3.0.0-alpha.2**

This update included:

* MSAG (4) tool has been written - `MSAG/TN-NG911 Comparison`.
* Comparison (5) tools have been written - `Compare NG911 Feature Classes`, `Compare NG911 Geodatabases.`
* Submission (6) tools have been written - `Check All and Zip`, `Export to Shapefiles`, `Export to Zip`.
* Validation tool output fixed.
* Enhancement Tool - `Add Topology` has been written.
* Enhancement Tool - `Generate Fishbone Analysis` has **not** been written.
* Documentation updated but not completely.

### **Version 3.0.0-alpha.1**

![Desktop to Pro Infographic](Doc/img/NG911_Desktop_to_Pro_infographic_Light.png)

This update included:

* Convert from **Desktop** version of the Toolkit to **Pro** version of the Toolkit.
* Collapse all Adjustment and most Enhancment tools into one Enhancement tool.
* Validation tools collapsed into one tool.
* Assign NGUID tool moved to Prep tools.
* All Field Map tools collapsed into one tool.
* Comparison, MSAG, and Submission tools have not been written.
* Generate Fishbone Analysis tool has not been written.
* Toolkit open for alpha test.

## Support Contact

For issues or questions, please contact through email Riley Baird at <rbaird@odot.org> or Emma Baker at <ebaker@odot.org> with the Oklahoma Transportation Cabinet, and please include in the email which script you were running, any error messages, and a zipped copy of your geodatabase. Change the file extension from `zip` to `piz` so it gets through the email server. If there are further data transfer issues, contact Emma or Riley to make alternative data transfer arrangements.

## **Disclaimer**

The Oklahoma NG9-1-1 GIS Toolbox is provided by the Oklahoma Geographic Information (GI) Council, Oklahoma 9-1-1 Management Authority, Oklahoma Department of Transportation (ODOT), Oklahoma Office of Geographic Information (OGI) , and associated contributors "as is" and any express or implied warranties, including, but not limited to, the implied warranties of merchantability and fitness for a particular purpose are disclaimed.  In no event shall the Oklahoma GI Council, Oklahoma 9-1-1 Management Authority, ODOT, OGI, or associated contributors be liable for any direct, indirect, incidental, special, exemplary, or consequential damages (including, but not limited to, procurement of substitute goods or services; loss of use, data, or profits; or business interruption) however caused and on any theory of liability, whether in contract, strict liability, or tort (including negligence or otherwise) arising in any way out of the use of this software, even if advised of the possibility of such damage.

<!-- External Doc links -->
[Prep]: Doc/Prep.html
[Adjustment]: Doc/Adjustment.html
[Comparison]: Doc/Comparison.html
[Enhancement]: Doc/Enhancement.html
[MSAG]: Doc/MSAG.html
[Submission]: Doc/Submission.html
[Validation]: Doc/Validation.html
[Topology Rules]: Doc/Topology.html
[Change Log]: ChangeLog.html
[Error Glossary]: Doc/ErrorGlossary.html
[Examples]: Doc/Examples.html
[Generate Fishbone Analysis]: Doc/FishboneAddressVerification.html
